clear;
rng(12345); % Set seed for reproducibility

n = 2; 
m = 2;

%% Define Nonconvex Functions
% function 1
f = @(x) (x(1)+pi/20)^2 + (x(2)+1)^2; % Objective function
grad_f = @(x) [2*(x(1)+pi/20); 2*(x(2)+1)]; % Gradient of f
% 
g = @(x) (x(2)-sin(10*x(1)))^2; % Constraint function
grad_g = @(x) [-2*cos(10*x(1))*(x(2)-sin(10*x(1))); 2*(x(2)-sin(10*x(1)))]; % Gradient of g

% % function 2
% f = @(x) (x(1))^2 + (x(2))^2; % Objective function
% grad_f = @(x) [2*(x(1)); 2*(x(2))]; % Gradient of f
% 
% g = @(x) (x(1)^2+x(2)^2-1)^2; % Constraint function
% grad_g = @(x) [4*x(1)*(x(1)^2+x(2)^2-1); 4*x(2)*(x(1)^2+x(2)^2-1)]; % Gradient of g

% function 3
% f = @(x) (x(1)-2)^2 + (x(2)-2)^2; % Objective function
% grad_f = @(x) [2*(x(1)-2); 2*(x(2)-2)]; % Gradient of f

% sin^2
% g = @(x) sin(x(1))^2 + sin(x(2))^2; % Constraint function
% grad_g = @(x) [sin(2*(x(1))); sin(2*x(2))]; % Gradient of g

% ring function
% g = @(x) (x(1)^2 + x(2)^2 - 1)^4;
% 
% grad_g = @(x) ...
%     [
%         8 * x(1) * ( x(1)^2 + x(2)^2 - 1 )^3;
%         8 * x(2) * ( x(1)^2 + x(2)^2 - 1 )^3
%     ];

% % Rosenbrock’s “Banana” Function
% 
% g = @(x) 100*(x(2) - x(1)^2)^2 + (1 - x(1))^2;
% 
% % Gradient of the Rosenbrock function
% grad_g = @(x) [
%     -400*x(1)*(x(2) - x(1)^2) - 2*(1 - x(1));  % df/dx
%     200*(x(2) - x(1)^2)                       % df/dy
% ];

% Rastrigin function in 2D
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% g = @(x) ...
%     20 ...
%     + x(1)^2 - 10*cos(2*pi*x(1)) ...
%     + x(2)^2 - 10*cos(2*pi*x(2));
% 
% grad_g = @(x) [
%     2*x(1) + 20*pi*sin(2*pi*x(1));
%     2*x(2) + 20*pi*sin(2*pi*x(2))
% ];
%% Set Optimization Parameters
accuracy = 1e-5 / 2; 
param.epsilong = accuracy; 
param.epsilonf = accuracy * 2; 

param.max_iter = 500;
param.stepsize = 1e-2;

%% Initialize Starting Point
x01 = [3; 0];
x02 = [0; -2];
x03 = [-3; -1];

%% Solve Bilevel Optimization with DBGD
param.beta = 1;
[x_last1, f_vec1, g_vec1, f_par1, f_orth1,angle1, lam_vec1, x1_hist] = DBGD_new(f, grad_f, g, grad_g, param, x01);
[x_last2, f_vec2, g_vec2, f_par2, f_orth2, angle2, lam_vec2, x2_hist] = DBGD_new(f, grad_f, g, grad_g, param, x02);
[x_last3, f_vec3, g_vec3, f_par3, f_orth3,angle3, lam_vec3, x3_hist] = DBGD_new(f, grad_f, g, grad_g, param, x03);

%% 1. Plot Solution Trajectory with Contour Plot
figure;
hold on; grid on;

% Define x and y ranges for contour plot, restricted to [-3,3] x [-2,1]
x_range = linspace(-3, 3, 100);
y_range = linspace(-2, 1, 100);

[X, Y] = meshgrid(x_range, y_range);
Z = (X + pi/20).^2 + (Y + 1).^2;  % Compute function values

% Plot contour of the function (x1 + pi/20)^2 + (x2 + 1)^2 with limited area
contour(X, Y, Z, 10, 'LineWidth', 1, 'DisplayName', 'Contour of $f(x)$');

% Plot x1_hist trajectory in blue with 'x' marker
plot(x1_hist(:,1), x1_hist(:,2), 'bo', 'DisplayName', 'Initialization 1');
plot(x1_hist(end,1), x1_hist(end,2), 'bx', 'MarkerSize', 15, 'LineWidth', 5, 'DisplayName', 'Initialization 1 Last');

% Plot x2_hist trajectory in green with 'o' marker
plot(x2_hist(:,1), x2_hist(:,2), 'go', 'DisplayName', 'Initialization 2');
plot(x2_hist(end,1), x2_hist(end,2), 'gx', 'MarkerSize', 15, 'LineWidth', 5,'DisplayName', 'Initialization 2 Last');

% Plot x3_hist trajectory in cyan with '*' marker
plot(x3_hist(:,1), x3_hist(:,2), 'ro', 'DisplayName', 'Initialization 3');
plot(x3_hist(end,1), x3_hist(end,2), 'rx', 'MarkerSize', 15, 'LineWidth', 5,'DisplayName', 'Initialization 3 Last');

% Add y = sin(10*x) plot with a black dashed line and LaTeX formatted label
fplot(@(x) sin(10*x), [-3, 3], 'k--', 'LineWidth', 1.5, 'DisplayName', '$\mathcal{X}_{g}^{*}$');

% Enable LaTeX interpreter for the legend
legend('Location', 'best', 'Interpreter', 'latex', 'FontSize', 16);

% Set axis limits to match the requested area
xlim([-3, 3]);
ylim([-2, 1]);

set(gca, 'FontSize', 18);
% Set labels and title
xlabel('$x_1$', 'Interpreter', 'latex','FontSize', 20,'FontWeight', 'bold'); 
ylabel('$x_2$', 'Interpreter', 'latex','FontSize', 20,'FontWeight', 'bold'); 
% title('Trajectory with Different Initializations');

hold off;


%% 2. Plot lambda_k for all three cases in one figure
figure;
hold on; grid on;

% Plot each lambda sequence with distinct colors
semilogy(lam_vec1, 'b-.', 'LineWidth', 3, 'DisplayName', 'Initialization 1');
semilogy(lam_vec2, 'g-.', 'LineWidth', 3, 'DisplayName', 'Initialization 2');
semilogy(lam_vec3, 'r-.', 'LineWidth', 3, 'DisplayName', 'Initialization 3');

% Explicitly set y-axis to log scale
set(gca, 'YScale', 'log', 'FontSize', 18);

% Labels and title
ylabel('$\lambda_k$', 'Interpreter', 'latex', 'FontSize', 20); 
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 18);
% title('Weights');

% Enable legend
legend('Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);

hold off;

%% 3. Plot f_par for all three cases in one figure
figure;
hold on; grid on;

% Plot each lambda sequence with distinct colors
semilogy(f_par1, 'b-.', 'LineWidth', 3, 'DisplayName', 'Initialization 1');
semilogy(f_par2, 'g-.', 'LineWidth', 3, 'DisplayName', 'Initialization 2');
semilogy(f_par3, 'r-.', 'LineWidth', 3, 'DisplayName', 'Initialization 3');

% Explicitly set y-axis to log scale
set(gca, 'YScale', 'log', 'FontSize', 18);

% Labels and title
ylabel('$\|\nabla_{\|} f\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 18);
% title('Weights');

% Enable legend
legend('Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);

hold off;

%% 4. Plot f_orth for all three cases in one figure
figure;
hold on; grid on;

% Plot each lambda sequence with distinct colors
semilogy(f_orth1, 'b-.', 'LineWidth', 3, 'DisplayName', 'Initialization 1');
semilogy(f_orth2, 'g-.', 'LineWidth', 3, 'DisplayName', 'Initialization 2');
semilogy(f_orth3, 'r-.', 'LineWidth', 3, 'DisplayName', 'Initialization 3');

% Explicitly set y-axis to log scale
set(gca, 'YScale', 'log', 'FontSize', 18);

% Labels and title
ylabel('$\|\nabla_{\perp} f\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 18); 
% title('Weights');

% Enable legend
legend('Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);

hold off;

%% 5. Plot f_orth for all three cases in one figure
figure;
hold on; grid on;

% Plot each lambda sequence with distinct colors
semilogy(g_vec1, 'b-.', 'LineWidth', 3, 'DisplayName', 'Initialization 1');
semilogy(g_vec2, 'g-.', 'LineWidth', 3, 'DisplayName', 'Initialization 2');
semilogy(g_vec3, 'r-.', 'LineWidth', 3, 'DisplayName', 'Initialization 3');

% Explicitly set y-axis to log scale
set(gca, 'YScale', 'log', 'FontSize', 18);

% Labels and title
ylabel('$\|\nabla g\|^2$', 'Interpreter', 'latex', 'FontSize', 20); 
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 18);
% title('Weights');

% Enable legend
legend('Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);

hold off;

%% 6. Plot angle for all three cases in one figure
figure;
hold on; grid on;

% Plot each lambda sequence with distinct colors
plot(angle1, 'b-.', 'LineWidth', 3, 'DisplayName', 'Initialization 1');
plot(angle2, 'g-.', 'LineWidth', 3, 'DisplayName', 'Initialization 2');
plot(angle3, 'r-.', 'LineWidth', 3, 'DisplayName', 'Initialization 3');

% Explicitly set y-axis to log scale
% set(gca, 'YScale', 'log');
set(gca, 'FontSize', 18);
% Labels and title
ylabel('$\cos \theta$', 'Interpreter', 'latex', 'FontSize', 20); 
xlabel('\textbf{Number of Iterations}', 'Interpreter', 'latex', 'FontSize', 18); 
% title('Weights');

% Enable legend
legend('Location', 'southwest', 'Interpreter', 'latex', 'FontSize', 18);

hold off;
